<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenPago extends Model 
{

    protected $table = 'orden_pago';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function ordenPagoFactura()
    {
        return $this->hasMany('App\Models\OrdenPagoFactura');
    }

    public function proveedor()
    {
        return $this->belongsTo('App\Models\Proveedor');
    }

}